function initDonutChart() {
    Morris.Donut({
        element: "donut_chart",
        data: [{
            label: "Tablet",
            value: 15
        }, {
            label: "Desktops",
            value: 45
        }, {
            label: "Mobile",
            value: 40
        }],
        colors: ["#3aaaec", "#7868da", "#fb4364"],
        backgroundColor: "#1c222c",
        formatter: function(i) {
            return i + "%"
        }
    })
}

function MorrisArea() {
    Morris.Area({
        element: "m_area_chart2",
        data: [{
            period: "2012",
            SiteA: 10,
            SiteB: 0
        }, {
            period: "2013",
            SiteA: 126,
            SiteB: 78
        }, {
            period: "2014",
            SiteA: 78,
            SiteB: 58
        }, {
            period: "2015",
            SiteA: 89,
            SiteB: 185
        }, {
            period: "2016",
            SiteA: 175,
            SiteB: 124
        }, {
            period: "2017",
            SiteA: 126,
            SiteB: 102
        }],
        xkey: "period",
        ykeys: ["SiteA", "SiteB"],
        labels: ["Site A", "Site B"],
        pointSize: 0,
        fillOpacity: .4,
        pointStrokeColors: ["#2CA8FF", "#18ce0f"],
        behaveLikeLine: !0,
        gridLineColor: "#27303e",
        lineWidth: 1,
        smooth: !1,
        hideHover: "auto",
        lineColors: ["#2CA8FF", "#18ce0f"],
        resize: !0
    }), Morris.Area({
        element: "m_area_chart",
        data: [{
            period: "2011",
            iphone: 22,
            ipad: 5,
            itouch: 55
        }, {
            period: "2012",
            iphone: 33,
            ipad: 11,
            itouch: 155
        }, {
            period: "2013",
            iphone: 17,
            ipad: 23,
            itouch: 55
        }, {
            period: "2014",
            iphone: 55,
            ipad: 17,
            itouch: 55
        }, {
            period: "2015",
            iphone: 78,
            ipad: 98,
            itouch: 140
        }, {
            period: "2016",
            iphone: 59,
            ipad: 78,
            itouch: 85
        }, {
            period: "2017",
            iphone: 170,
            ipad: 156,
            itouch: 120
        }],
        xkey: "period",
        ykeys: ["iphone", "ipad", "itouch"],
        labels: ["iPhone", "iPad", "iPod Touch"],
        pointSize: 1,
        fillOpacity: 0,
        pointStrokeColors: ["#ffffff", "#72c2ff", "#ffc107"],
        behaveLikeLine: !0,
        gridLineColor: "#27303e",
        lineWidth: 1,
        hideHover: "auto",
        lineColors: ["#ffffff", "#72c2ff", "#ffc107"],
        resize: !0
    })
}

function Jknob() {
    $(".knob").knob({
        draw: function() {
            if ("tron" == this.$.data("skin")) {
                var i, e = this.angle(this.cv),
                    t = this.startAngle,
                    o = this.startAngle,
                    r = o + e;
                return this.g.lineWidth = this.lineWidth, this.o.cursor && (o = r - .3) && (r += .3), this.o.displayPrevious && (i = this.startAngle + this.angle(this.value), this.o.cursor && (t = i - .3) && (i += .3), this.g.beginPath(), this.g.strokeStyle = this.previousColor, this.g.arc(this.xy, this.xy, this.radius - this.lineWidth, t, i, !1), this.g.stroke()), this.g.beginPath(), this.g.strokeStyle = this.o.fgColor, this.g.arc(this.xy, this.xy, this.radius - this.lineWidth, o, r, !1), this.g.stroke(), this.g.lineWidth = 2, this.g.beginPath(), this.g.strokeStyle = this.o.fgColor, this.g.arc(this.xy, this.xy, this.radius - this.lineWidth + 1 + 2 * this.lineWidth / 3, 0, 2 * Math.PI, !1), this.g.stroke(), !1
            }
        }
    })
}
$(function() {
    "use strict";
    initDonutChart(), MorrisArea(), Jknob()
}), $("#sparkline16").sparkline([155, 161, 170, 205, 198, 245, 279, 301, 423], {
    type: "line",
    width: "100%",
    height: "390",
    chartRangeMax: 100,
    resize: !0,
    lineColor: "#84b3df",
    fillColor: "#d2e7fb",
    highlightLineColor: "rgba(0,0,0,.1)",
    highlightSpotColor: "rgba(0,0,0,.2)"
}), $("#sparkline16").sparkline([4, 5, 7, 5, 10, 12, 22, 32, 41, 32], {
    type: "line",
    width: "100%",
    height: "290",
    chartRangeMax: 100,
    lineColor: "#8f8ff0",
    fillColor: "#b5b5ea",
    composite: !0,
    resize: !0,
    highlightLineColor: "rgba(0,0,0,.1)",
    highlightSpotColor: "rgba(0,0,0,.2)"
}), $(window).on("scroll", function() {
    $(".card .sparkline").each(function() {
        $(this).offset().top < $(window).scrollTop() + 400 && $(this).addClass("pullUp")
    })
}), $(function() {
    "use strict";
    $("#world-map-markers").length > 0 && $("#world-map-markers").vectorMap({
        map: "world_mill_en",
        backgroundColor: "transparent",
        borderColor: "#fff",
        borderOpacity: .25,
        borderWidth: 0,
        color: "#e6e6e6",
        regionStyle: {
            initial: {
                fill: "#f4f4f4"
            }
        },
        markerStyle: {
            initial: {
                r: 5,
                fill: "#fff",
                "fill-opacity": 1,
                stroke: "#000",
                "stroke-width": 1,
                "stroke-opacity": .4
            }
        },
        markers: [{
            latLng: [21, 78],
            name: "INDIA : 350"
        }, {
            latLng: [-33, 151],
            name: "Australia : 250"
        }, {
            latLng: [36.77, -119.41],
            name: "USA : 250"
        }, {
            latLng: [55.37, -3.41],
            name: "UK   : 250"
        }, {
            latLng: [25.2, 55.27],
            name: "UAE : 250"
        }],
        series: {
            regions: [{
                values: {
                    US: "#49c5b6",
                    SA: "#667add",
                    AU: "#50d38a",
                    IN: "#60bafd",
                    GB: "#ff758e"
                },
                attribute: "fill"
            }]
        },
        hoverOpacity: null,
        normalizeFunction: "linear",
        zoomOnScroll: !1,
        scaleColors: ["#000000", "#000000"],
        selectedColor: "#000000",
        selectedRegions: [],
        enableZoom: !1,
        hoverColor: "#fff"
    }), $("#india").length > 0 && $("#india").vectorMap({
        map: "in_mill",
        backgroundColor: "transparent",
        regionStyle: {
            initial: {
                fill: "#f4f4f4"
            }
        }
    }), $("#usa").length > 0 && $("#usa").vectorMap({
        map: "us_aea_en",
        backgroundColor: "transparent",
        regionStyle: {
            initial: {
                fill: "#f4f4f4"
            }
        }
    }), $("#australia").length > 0 && $("#australia").vectorMap({
        map: "au_mill",
        backgroundColor: "transparent",
        regionStyle: {
            initial: {
                fill: "#f4f4f4"
            }
        }
    }), $("#uk").length > 0 && $("#uk").vectorMap({
        map: "uk_mill_en",
        backgroundColor: "transparent",
        regionStyle: {
            initial: {
                fill: "#f4f4f4"
            }
        }
    })
});