$(function(){

	calc();

	$('#calc_plan').on('change', calc);
	$('#inv_amount').bind('change keyup', calc).on('keypress', isNumberKey);

});

function isNumberKey(evt) {
	var charCode = (evt.which) ? evt.which : event.keyCode;
	if (charCode > 31 && (charCode < 45 || charCode > 57))
		return false;
	return true;
}

function calc() {

	var plan = $('#calc_plan').val();
	var amount = $('#inv_amount').val();
	var percent;

	switch (plan) {
		case '1':
			switch (true) {
				case (amount<20):
					percent = "   Min $20    ";
					break;
				case (amount<=500):
					percent = 102.5;
					break;
				case (amount<=1000):
					percent = 104;
					break;
				case (amount<=5000):
					percent = 107;
					break;
				case (amount<=10000):
					percent = 115;
					break;
				case (amount<=100000):
					percent = 125;

			}
			break;
			
		case '2':
			switch (true) {
				case (amount<300):
					percent = "   Min $300    ";
					break;
				case (amount<=1000):
					percent = 110;
					break;
				case (amount<=3000):
					percent = 115;
					break;
				case (amount<=5000):
					percent = 120;
					break;
				case (amount<=10000):
					percent = 130;
					break;
				case (amount<=100000):
					percent = 150;
			}
			break;
			
		case '3':
			switch (true) {
				case (amount<20):
					percent = "   Min $20    ";
					break;
				case (amount<=500):
					percent = 107;
					break;
				case (amount<=1000):
					percent = 110;
					break;
				case (amount<=5000):
					percent = 115;
					break;
				case (amount<=10000):
					percent = 140;
					break;
				case (amount<=100000):
					percent = 180;
			}
			break;
			
		case '4':
			switch (true) {
				case (amount<20):
					percent = "   Min $20    ";
					break;
				case (amount<=500):
					percent = 120;
					break;
				case (amount<=1000):
					percent = 140;
					break;
				case (amount<=5000):
					percent = 180;
					break;
				case (amount<=10000):
					percent = 220;
					break;
				case (amount<=100000):
					percent = 250;
			}
			break;
			
		case '5':
			switch (true) {
				case (amount<20):
					percent = "   Min $20    ";
					break;
				case (amount<=500):
					percent = 135;
					break;
				case (amount<=1000):
					percent = 160;
					break;
				case (amount<=5000):
					percent = 200;
					break;
				case (amount<=10000):
					percent = 280;
					break;
				case (amount<=100000):
					percent = 350;
			}
			break;
			
		case '6':
			switch (true) {
				case (amount<20):
					percent = "   Min $20    ";
					break;
				case (amount<=500):
					percent = 230;
					break;
				case (amount<=1000):
					percent = 280;
					break;
				case (amount<=5000):
					percent = 350;
					break;
				case (amount<=10000):
					percent = 430;
					break;
				case (amount<=100000):
					percent = 520;
			}
			break;
	}

$('#assign_per').val(percent+'%');
	var total = amount*percent/100;
	$('#total_return').val('$'+total.toFixed(2));
	
	if(total <= 0){
		$('#net_profit').val('0.00');
	}else{
		$('#net_profit').val('$'+(total-amount).toFixed(2));
	}

}